/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchainquery;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.managedblockchainquery.AmazonManagedBlockchainQueryAsync;
import com.amazonaws.services.managedblockchainquery.AmazonManagedBlockchainQueryAsyncClientBuilder;
import com.amazonaws.services.managedblockchainquery.AmazonManagedBlockchainQueryClient;
import com.amazonaws.services.managedblockchainquery.model.BatchGetTokenBalanceRequest;
import com.amazonaws.services.managedblockchainquery.model.BatchGetTokenBalanceResult;
import com.amazonaws.services.managedblockchainquery.model.GetTokenBalanceRequest;
import com.amazonaws.services.managedblockchainquery.model.GetTokenBalanceResult;
import com.amazonaws.services.managedblockchainquery.model.GetTransactionRequest;
import com.amazonaws.services.managedblockchainquery.model.GetTransactionResult;
import com.amazonaws.services.managedblockchainquery.model.ListTokenBalancesRequest;
import com.amazonaws.services.managedblockchainquery.model.ListTokenBalancesResult;
import com.amazonaws.services.managedblockchainquery.model.ListTransactionEventsRequest;
import com.amazonaws.services.managedblockchainquery.model.ListTransactionEventsResult;
import com.amazonaws.services.managedblockchainquery.model.ListTransactionsRequest;
import com.amazonaws.services.managedblockchainquery.model.ListTransactionsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonManagedBlockchainQueryAsyncClient
extends AmazonManagedBlockchainQueryClient
implements AmazonManagedBlockchainQueryAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonManagedBlockchainQueryAsyncClientBuilder asyncBuilder() {
        return AmazonManagedBlockchainQueryAsyncClientBuilder.standard();
    }

    AmazonManagedBlockchainQueryAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonManagedBlockchainQueryAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetTokenBalanceResult> batchGetTokenBalanceAsync(BatchGetTokenBalanceRequest request) {
        return this.batchGetTokenBalanceAsync(request, null);
    }

    @Override
    public Future<BatchGetTokenBalanceResult> batchGetTokenBalanceAsync(BatchGetTokenBalanceRequest request, final AsyncHandler<BatchGetTokenBalanceRequest, BatchGetTokenBalanceResult> asyncHandler) {
        final BatchGetTokenBalanceRequest finalRequest = (BatchGetTokenBalanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetTokenBalanceResult>(){

            @Override
            public BatchGetTokenBalanceResult call() throws Exception {
                BatchGetTokenBalanceResult result = null;
                try {
                    result = AmazonManagedBlockchainQueryAsyncClient.this.executeBatchGetTokenBalance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTokenBalanceResult> getTokenBalanceAsync(GetTokenBalanceRequest request) {
        return this.getTokenBalanceAsync(request, null);
    }

    @Override
    public Future<GetTokenBalanceResult> getTokenBalanceAsync(GetTokenBalanceRequest request, final AsyncHandler<GetTokenBalanceRequest, GetTokenBalanceResult> asyncHandler) {
        final GetTokenBalanceRequest finalRequest = (GetTokenBalanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTokenBalanceResult>(){

            @Override
            public GetTokenBalanceResult call() throws Exception {
                GetTokenBalanceResult result = null;
                try {
                    result = AmazonManagedBlockchainQueryAsyncClient.this.executeGetTokenBalance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTransactionResult> getTransactionAsync(GetTransactionRequest request) {
        return this.getTransactionAsync(request, null);
    }

    @Override
    public Future<GetTransactionResult> getTransactionAsync(GetTransactionRequest request, final AsyncHandler<GetTransactionRequest, GetTransactionResult> asyncHandler) {
        final GetTransactionRequest finalRequest = (GetTransactionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTransactionResult>(){

            @Override
            public GetTransactionResult call() throws Exception {
                GetTransactionResult result = null;
                try {
                    result = AmazonManagedBlockchainQueryAsyncClient.this.executeGetTransaction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTokenBalancesResult> listTokenBalancesAsync(ListTokenBalancesRequest request) {
        return this.listTokenBalancesAsync(request, null);
    }

    @Override
    public Future<ListTokenBalancesResult> listTokenBalancesAsync(ListTokenBalancesRequest request, final AsyncHandler<ListTokenBalancesRequest, ListTokenBalancesResult> asyncHandler) {
        final ListTokenBalancesRequest finalRequest = (ListTokenBalancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTokenBalancesResult>(){

            @Override
            public ListTokenBalancesResult call() throws Exception {
                ListTokenBalancesResult result = null;
                try {
                    result = AmazonManagedBlockchainQueryAsyncClient.this.executeListTokenBalances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTransactionEventsResult> listTransactionEventsAsync(ListTransactionEventsRequest request) {
        return this.listTransactionEventsAsync(request, null);
    }

    @Override
    public Future<ListTransactionEventsResult> listTransactionEventsAsync(ListTransactionEventsRequest request, final AsyncHandler<ListTransactionEventsRequest, ListTransactionEventsResult> asyncHandler) {
        final ListTransactionEventsRequest finalRequest = (ListTransactionEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTransactionEventsResult>(){

            @Override
            public ListTransactionEventsResult call() throws Exception {
                ListTransactionEventsResult result = null;
                try {
                    result = AmazonManagedBlockchainQueryAsyncClient.this.executeListTransactionEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTransactionsResult> listTransactionsAsync(ListTransactionsRequest request) {
        return this.listTransactionsAsync(request, null);
    }

    @Override
    public Future<ListTransactionsResult> listTransactionsAsync(ListTransactionsRequest request, final AsyncHandler<ListTransactionsRequest, ListTransactionsResult> asyncHandler) {
        final ListTransactionsRequest finalRequest = (ListTransactionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTransactionsResult>(){

            @Override
            public ListTransactionsResult call() throws Exception {
                ListTransactionsResult result = null;
                try {
                    result = AmazonManagedBlockchainQueryAsyncClient.this.executeListTransactions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

