/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.managedblockchainquery.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.managedblockchainquery.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * TokenBalanceMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class TokenBalanceMarshaller {

    private static final MarshallingInfo<StructuredPojo> OWNERIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownerIdentifier").build();
    private static final MarshallingInfo<StructuredPojo> TOKENIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenIdentifier").build();
    private static final MarshallingInfo<String> BALANCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("balance").build();
    private static final MarshallingInfo<StructuredPojo> ATBLOCKCHAININSTANT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("atBlockchainInstant").build();
    private static final MarshallingInfo<StructuredPojo> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTime").build();

    private static final TokenBalanceMarshaller instance = new TokenBalanceMarshaller();

    public static TokenBalanceMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(TokenBalance tokenBalance, ProtocolMarshaller protocolMarshaller) {

        if (tokenBalance == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(tokenBalance.getOwnerIdentifier(), OWNERIDENTIFIER_BINDING);
            protocolMarshaller.marshall(tokenBalance.getTokenIdentifier(), TOKENIDENTIFIER_BINDING);
            protocolMarshaller.marshall(tokenBalance.getBalance(), BALANCE_BINDING);
            protocolMarshaller.marshall(tokenBalance.getAtBlockchainInstant(), ATBLOCKCHAININSTANT_BINDING);
            protocolMarshaller.marshall(tokenBalance.getLastUpdatedTime(), LASTUPDATEDTIME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
