/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointanalytics.model.transform;

import com.amazonaws.services.pinpointanalytics.model.Event;
import com.amazonaws.services.pinpointanalytics.model.Session;
import com.amazonaws.services.pinpointanalytics.model.transform.SessionJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Map;

class EventJsonMarshaller {
    private static EventJsonMarshaller instance;

    EventJsonMarshaller() {
    }

    public void marshall(Event event, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (event.getEventType() != null) {
            String eventType = event.getEventType();
            jsonWriter.name("eventType");
            jsonWriter.value(eventType);
        }
        if (event.getTimestamp() != null) {
            String timestamp = event.getTimestamp();
            jsonWriter.name("timestamp");
            jsonWriter.value(timestamp);
        }
        if (event.getSession() != null) {
            Session session = event.getSession();
            jsonWriter.name("session");
            SessionJsonMarshaller.getInstance().marshall(session, jsonWriter);
        }
        if (event.getVersion() != null) {
            String version = event.getVersion();
            jsonWriter.name("version");
            jsonWriter.value(version);
        }
        if (event.getAttributes() != null) {
            Map<String, String> attributes = event.getAttributes();
            jsonWriter.name("attributes");
            jsonWriter.beginObject();
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String attributesValue = (String)entry.getValue();
                if (attributesValue == null) continue;
                jsonWriter.name(entry.getKey());
                jsonWriter.value(attributesValue);
            }
            jsonWriter.endObject();
        }
        if (event.getMetrics() != null) {
            Map<String, Double> metrics = event.getMetrics();
            jsonWriter.name("metrics");
            jsonWriter.beginObject();
            for (Map.Entry<String, Object> entry : metrics.entrySet()) {
                Double metricsValue = (Double)entry.getValue();
                if (metricsValue == null) continue;
                jsonWriter.name(entry.getKey());
                jsonWriter.value((Number)metricsValue);
            }
            jsonWriter.endObject();
        }
        jsonWriter.endObject();
    }

    public static EventJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EventJsonMarshaller();
        }
        return instance;
    }
}

