/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.MessageConfiguration;
import com.amazonaws.services.pinpoint.model.Schedule;
import com.amazonaws.services.pinpoint.model.WriteTreatmentResource;
import com.amazonaws.services.pinpoint.model.transform.MessageConfigurationJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.ScheduleJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;

class WriteTreatmentResourceJsonMarshaller {
    private static WriteTreatmentResourceJsonMarshaller instance;

    WriteTreatmentResourceJsonMarshaller() {
    }

    public void marshall(WriteTreatmentResource writeTreatmentResource, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (writeTreatmentResource.getMessageConfiguration() != null) {
            MessageConfiguration messageConfiguration = writeTreatmentResource.getMessageConfiguration();
            jsonWriter.name("MessageConfiguration");
            MessageConfigurationJsonMarshaller.getInstance().marshall(messageConfiguration, jsonWriter);
        }
        if (writeTreatmentResource.getSchedule() != null) {
            Schedule schedule = writeTreatmentResource.getSchedule();
            jsonWriter.name("Schedule");
            ScheduleJsonMarshaller.getInstance().marshall(schedule, jsonWriter);
        }
        if (writeTreatmentResource.getSizePercent() != null) {
            Integer sizePercent = writeTreatmentResource.getSizePercent();
            jsonWriter.name("SizePercent");
            jsonWriter.value((Number)sizePercent);
        }
        if (writeTreatmentResource.getTreatmentDescription() != null) {
            String treatmentDescription = writeTreatmentResource.getTreatmentDescription();
            jsonWriter.name("TreatmentDescription");
            jsonWriter.value(treatmentDescription);
        }
        if (writeTreatmentResource.getTreatmentName() != null) {
            String treatmentName = writeTreatmentResource.getTreatmentName();
            jsonWriter.name("TreatmentName");
            jsonWriter.value(treatmentName);
        }
        jsonWriter.endObject();
    }

    public static WriteTreatmentResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WriteTreatmentResourceJsonMarshaller();
        }
        return instance;
    }
}

