/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.UpdateSegmentRequest;
import com.amazonaws.services.pinpoint.model.WriteSegmentRequest;
import com.amazonaws.services.pinpoint.model.transform.WriteSegmentRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateSegmentRequestMarshaller
implements Marshaller<Request<UpdateSegmentRequest>, UpdateSegmentRequest> {
    public Request<UpdateSegmentRequest> marshall(UpdateSegmentRequest updateSegmentRequest) {
        if (updateSegmentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateSegmentRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateSegmentRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateSegmentRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)updateSegmentRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/segments/{segment-id}";
        uriResourcePath = uriResourcePath.replace("{application-id}", updateSegmentRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)updateSegmentRequest.getApplicationId()));
        uriResourcePath = uriResourcePath.replace("{segment-id}", updateSegmentRequest.getSegmentId() == null ? "" : StringUtils.fromString((String)updateSegmentRequest.getSegmentId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            if (updateSegmentRequest.getWriteSegmentRequest() != null) {
                WriteSegmentRequest writeSegmentRequest = updateSegmentRequest.getWriteSegmentRequest();
                WriteSegmentRequestJsonMarshaller.getInstance().marshall(writeSegmentRequest, jsonWriter);
            }
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

