/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GCMChannelRequest;
import com.amazonaws.services.pinpoint.model.UpdateGcmChannelRequest;
import com.amazonaws.services.pinpoint.model.transform.GCMChannelRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateGcmChannelRequestMarshaller
implements Marshaller<Request<UpdateGcmChannelRequest>, UpdateGcmChannelRequest> {
    public Request<UpdateGcmChannelRequest> marshall(UpdateGcmChannelRequest updateGcmChannelRequest) {
        if (updateGcmChannelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateGcmChannelRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateGcmChannelRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateGcmChannelRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)updateGcmChannelRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/channels/gcm";
        uriResourcePath = uriResourcePath.replace("{application-id}", updateGcmChannelRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)updateGcmChannelRequest.getApplicationId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            if (updateGcmChannelRequest.getGCMChannelRequest() != null) {
                GCMChannelRequest gCMChannelRequest = updateGcmChannelRequest.getGCMChannelRequest();
                GCMChannelRequestJsonMarshaller.getInstance().marshall(gCMChannelRequest, jsonWriter);
            }
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

