/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.EndpointBatchRequest;
import com.amazonaws.services.pinpoint.model.UpdateEndpointsBatchRequest;
import com.amazonaws.services.pinpoint.model.transform.EndpointBatchRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateEndpointsBatchRequestMarshaller
implements Marshaller<Request<UpdateEndpointsBatchRequest>, UpdateEndpointsBatchRequest> {
    public Request<UpdateEndpointsBatchRequest> marshall(UpdateEndpointsBatchRequest updateEndpointsBatchRequest) {
        if (updateEndpointsBatchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateEndpointsBatchRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateEndpointsBatchRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateEndpointsBatchRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)updateEndpointsBatchRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/endpoints";
        uriResourcePath = uriResourcePath.replace("{application-id}", updateEndpointsBatchRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)updateEndpointsBatchRequest.getApplicationId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            if (updateEndpointsBatchRequest.getEndpointBatchRequest() != null) {
                EndpointBatchRequest endpointBatchRequest = updateEndpointsBatchRequest.getEndpointBatchRequest();
                EndpointBatchRequestJsonMarshaller.getInstance().marshall(endpointBatchRequest, jsonWriter);
            }
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

