/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.EndpointRequest;
import com.amazonaws.services.pinpoint.model.UpdateEndpointRequest;
import com.amazonaws.services.pinpoint.model.transform.EndpointRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateEndpointRequestMarshaller
implements Marshaller<Request<UpdateEndpointRequest>, UpdateEndpointRequest> {
    public Request<UpdateEndpointRequest> marshall(UpdateEndpointRequest updateEndpointRequest) {
        if (updateEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateEndpointRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateEndpointRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateEndpointRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)updateEndpointRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/endpoints/{endpoint-id}";
        uriResourcePath = uriResourcePath.replace("{application-id}", updateEndpointRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)updateEndpointRequest.getApplicationId()));
        uriResourcePath = uriResourcePath.replace("{endpoint-id}", updateEndpointRequest.getEndpointId() == null ? "" : StringUtils.fromString((String)updateEndpointRequest.getEndpointId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            if (updateEndpointRequest.getEndpointRequest() != null) {
                EndpointRequest endpointRequest = updateEndpointRequest.getEndpointRequest();
                EndpointRequestJsonMarshaller.getInstance().marshall(endpointRequest, jsonWriter);
            }
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

