/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.UpdateCampaignRequest;
import com.amazonaws.services.pinpoint.model.WriteCampaignRequest;
import com.amazonaws.services.pinpoint.model.transform.WriteCampaignRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateCampaignRequestMarshaller
implements Marshaller<Request<UpdateCampaignRequest>, UpdateCampaignRequest> {
    public Request<UpdateCampaignRequest> marshall(UpdateCampaignRequest updateCampaignRequest) {
        if (updateCampaignRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateCampaignRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateCampaignRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateCampaignRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)updateCampaignRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}";
        uriResourcePath = uriResourcePath.replace("{application-id}", updateCampaignRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)updateCampaignRequest.getApplicationId()));
        uriResourcePath = uriResourcePath.replace("{campaign-id}", updateCampaignRequest.getCampaignId() == null ? "" : StringUtils.fromString((String)updateCampaignRequest.getCampaignId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            if (updateCampaignRequest.getWriteCampaignRequest() != null) {
                WriteCampaignRequest writeCampaignRequest = updateCampaignRequest.getWriteCampaignRequest();
                WriteCampaignRequestJsonMarshaller.getInstance().marshall(writeCampaignRequest, jsonWriter);
            }
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

