/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.UpdateApplicationSettingsRequest;
import com.amazonaws.services.pinpoint.model.WriteApplicationSettingsRequest;
import com.amazonaws.services.pinpoint.model.transform.WriteApplicationSettingsRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateApplicationSettingsRequestMarshaller
implements Marshaller<Request<UpdateApplicationSettingsRequest>, UpdateApplicationSettingsRequest> {
    public Request<UpdateApplicationSettingsRequest> marshall(UpdateApplicationSettingsRequest updateApplicationSettingsRequest) {
        if (updateApplicationSettingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateApplicationSettingsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateApplicationSettingsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateApplicationSettingsRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)updateApplicationSettingsRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/settings";
        uriResourcePath = uriResourcePath.replace("{application-id}", updateApplicationSettingsRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)updateApplicationSettingsRequest.getApplicationId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            if (updateApplicationSettingsRequest.getWriteApplicationSettingsRequest() != null) {
                WriteApplicationSettingsRequest writeApplicationSettingsRequest = updateApplicationSettingsRequest.getWriteApplicationSettingsRequest();
                WriteApplicationSettingsRequestJsonMarshaller.getInstance().marshall(writeApplicationSettingsRequest, jsonWriter);
            }
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

