/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.APNSChannelRequest;
import com.amazonaws.services.pinpoint.model.UpdateApnsChannelRequest;
import com.amazonaws.services.pinpoint.model.transform.APNSChannelRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateApnsChannelRequestMarshaller
implements Marshaller<Request<UpdateApnsChannelRequest>, UpdateApnsChannelRequest> {
    public Request<UpdateApnsChannelRequest> marshall(UpdateApnsChannelRequest updateApnsChannelRequest) {
        if (updateApnsChannelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateApnsChannelRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateApnsChannelRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateApnsChannelRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)updateApnsChannelRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/channels/apns";
        uriResourcePath = uriResourcePath.replace("{application-id}", updateApnsChannelRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)updateApnsChannelRequest.getApplicationId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            if (updateApnsChannelRequest.getAPNSChannelRequest() != null) {
                APNSChannelRequest aPNSChannelRequest = updateApnsChannelRequest.getAPNSChannelRequest();
                APNSChannelRequestJsonMarshaller.getInstance().marshall(aPNSChannelRequest, jsonWriter);
            }
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

