/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.CampaignState;
import com.amazonaws.services.pinpoint.model.MessageConfiguration;
import com.amazonaws.services.pinpoint.model.Schedule;
import com.amazonaws.services.pinpoint.model.TreatmentResource;
import com.amazonaws.services.pinpoint.model.transform.CampaignStateJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.MessageConfigurationJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.ScheduleJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;

class TreatmentResourceJsonMarshaller {
    private static TreatmentResourceJsonMarshaller instance;

    TreatmentResourceJsonMarshaller() {
    }

    public void marshall(TreatmentResource treatmentResource, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (treatmentResource.getId() != null) {
            String id = treatmentResource.getId();
            jsonWriter.name("Id");
            jsonWriter.value(id);
        }
        if (treatmentResource.getMessageConfiguration() != null) {
            MessageConfiguration messageConfiguration = treatmentResource.getMessageConfiguration();
            jsonWriter.name("MessageConfiguration");
            MessageConfigurationJsonMarshaller.getInstance().marshall(messageConfiguration, jsonWriter);
        }
        if (treatmentResource.getSchedule() != null) {
            Schedule schedule = treatmentResource.getSchedule();
            jsonWriter.name("Schedule");
            ScheduleJsonMarshaller.getInstance().marshall(schedule, jsonWriter);
        }
        if (treatmentResource.getSizePercent() != null) {
            Integer sizePercent = treatmentResource.getSizePercent();
            jsonWriter.name("SizePercent");
            jsonWriter.value((Number)sizePercent);
        }
        if (treatmentResource.getState() != null) {
            CampaignState state = treatmentResource.getState();
            jsonWriter.name("State");
            CampaignStateJsonMarshaller.getInstance().marshall(state, jsonWriter);
        }
        if (treatmentResource.getTreatmentDescription() != null) {
            String treatmentDescription = treatmentResource.getTreatmentDescription();
            jsonWriter.name("TreatmentDescription");
            jsonWriter.value(treatmentDescription);
        }
        if (treatmentResource.getTreatmentName() != null) {
            String treatmentName = treatmentResource.getTreatmentName();
            jsonWriter.name("TreatmentName");
            jsonWriter.value(treatmentName);
        }
        jsonWriter.endObject();
    }

    public static TreatmentResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TreatmentResourceJsonMarshaller();
        }
        return instance;
    }
}

