/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.services.pinpoint.model.MessageBody;
import com.amazonaws.services.pinpoint.model.TooManyRequestsException;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.google.gson.Gson;

public class TooManyRequestsExceptionUnmarshaller
extends JsonErrorUnmarshaller {
    public TooManyRequestsExceptionUnmarshaller() {
        super(TooManyRequestsException.class);
    }

    public boolean match(JsonErrorResponseHandler.JsonErrorResponse error) throws Exception {
        return error.getErrorCode().equals("TooManyRequestsException");
    }

    public AmazonServiceException unmarshall(JsonErrorResponseHandler.JsonErrorResponse error) throws Exception {
        Gson gson = new Gson();
        TooManyRequestsException e = (TooManyRequestsException)super.unmarshall(error);
        e.setErrorCode("TooManyRequestsException");
        e.setAccessControlAllowOrigin(String.valueOf(error.get("AccessControlAllowOrigin")));
        e.setMessageBody((MessageBody)gson.fromJson(error.get("MessageBody"), MessageBody.class));
        return e;
    }
}

