/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.SegmentDimensions;
import com.amazonaws.services.pinpoint.model.SegmentImportResource;
import com.amazonaws.services.pinpoint.model.SegmentResponse;
import com.amazonaws.services.pinpoint.model.transform.SegmentDimensionsJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.SegmentImportResourceJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;

class SegmentResponseJsonMarshaller {
    private static SegmentResponseJsonMarshaller instance;

    SegmentResponseJsonMarshaller() {
    }

    public void marshall(SegmentResponse segmentResponse, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (segmentResponse.getApplicationId() != null) {
            String applicationId = segmentResponse.getApplicationId();
            jsonWriter.name("ApplicationId");
            jsonWriter.value(applicationId);
        }
        if (segmentResponse.getCreationDate() != null) {
            String creationDate = segmentResponse.getCreationDate();
            jsonWriter.name("CreationDate");
            jsonWriter.value(creationDate);
        }
        if (segmentResponse.getDimensions() != null) {
            SegmentDimensions dimensions = segmentResponse.getDimensions();
            jsonWriter.name("Dimensions");
            SegmentDimensionsJsonMarshaller.getInstance().marshall(dimensions, jsonWriter);
        }
        if (segmentResponse.getId() != null) {
            String id = segmentResponse.getId();
            jsonWriter.name("Id");
            jsonWriter.value(id);
        }
        if (segmentResponse.getImportDefinition() != null) {
            SegmentImportResource importDefinition = segmentResponse.getImportDefinition();
            jsonWriter.name("ImportDefinition");
            SegmentImportResourceJsonMarshaller.getInstance().marshall(importDefinition, jsonWriter);
        }
        if (segmentResponse.getLastModifiedDate() != null) {
            String lastModifiedDate = segmentResponse.getLastModifiedDate();
            jsonWriter.name("LastModifiedDate");
            jsonWriter.value(lastModifiedDate);
        }
        if (segmentResponse.getName() != null) {
            String name = segmentResponse.getName();
            jsonWriter.name("Name");
            jsonWriter.value(name);
        }
        if (segmentResponse.getSegmentType() != null) {
            String segmentType = segmentResponse.getSegmentType();
            jsonWriter.name("SegmentType");
            jsonWriter.value(segmentType);
        }
        if (segmentResponse.getVersion() != null) {
            Integer version = segmentResponse.getVersion();
            jsonWriter.name("Version");
            jsonWriter.value((Number)version);
        }
        jsonWriter.endObject();
    }

    public static SegmentResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SegmentResponseJsonMarshaller();
        }
        return instance;
    }
}

