/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.SegmentDimensions;
import com.amazonaws.services.pinpoint.model.transform.AttributeDimensionJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.SegmentBehaviorsJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.SegmentDemographicsJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.SegmentLocationJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class SegmentDimensionsJsonUnmarshaller
implements Unmarshaller<SegmentDimensions, JsonUnmarshallerContext> {
    private static SegmentDimensionsJsonUnmarshaller instance;

    SegmentDimensionsJsonUnmarshaller() {
    }

    public SegmentDimensions unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        SegmentDimensions segmentDimensions = new SegmentDimensions();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("Attributes")) {
                segmentDimensions.setAttributes(new MapUnmarshaller((Unmarshaller)AttributeDimensionJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("Behavior")) {
                segmentDimensions.setBehavior(SegmentBehaviorsJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Demographic")) {
                segmentDimensions.setDemographic(SegmentDemographicsJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Location")) {
                segmentDimensions.setLocation(SegmentLocationJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return segmentDimensions;
    }

    public static SegmentDimensionsJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SegmentDimensionsJsonUnmarshaller();
        }
        return instance;
    }
}

