/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.AttributeDimension;
import com.amazonaws.services.pinpoint.model.SegmentBehaviors;
import com.amazonaws.services.pinpoint.model.SegmentDemographics;
import com.amazonaws.services.pinpoint.model.SegmentDimensions;
import com.amazonaws.services.pinpoint.model.SegmentLocation;
import com.amazonaws.services.pinpoint.model.transform.AttributeDimensionJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.SegmentBehaviorsJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.SegmentDemographicsJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.SegmentLocationJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Map;

class SegmentDimensionsJsonMarshaller {
    private static SegmentDimensionsJsonMarshaller instance;

    SegmentDimensionsJsonMarshaller() {
    }

    public void marshall(SegmentDimensions segmentDimensions, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (segmentDimensions.getAttributes() != null) {
            Map<String, AttributeDimension> attributes = segmentDimensions.getAttributes();
            jsonWriter.name("Attributes");
            jsonWriter.beginObject();
            for (Map.Entry<String, AttributeDimension> attributesEntry : attributes.entrySet()) {
                AttributeDimension attributesValue = attributesEntry.getValue();
                if (attributesValue == null) continue;
                jsonWriter.name(attributesEntry.getKey());
                AttributeDimensionJsonMarshaller.getInstance().marshall(attributesValue, jsonWriter);
            }
            jsonWriter.endObject();
        }
        if (segmentDimensions.getBehavior() != null) {
            SegmentBehaviors behavior = segmentDimensions.getBehavior();
            jsonWriter.name("Behavior");
            SegmentBehaviorsJsonMarshaller.getInstance().marshall(behavior, jsonWriter);
        }
        if (segmentDimensions.getDemographic() != null) {
            SegmentDemographics demographic = segmentDimensions.getDemographic();
            jsonWriter.name("Demographic");
            SegmentDemographicsJsonMarshaller.getInstance().marshall(demographic, jsonWriter);
        }
        if (segmentDimensions.getLocation() != null) {
            SegmentLocation location = segmentDimensions.getLocation();
            jsonWriter.name("Location");
            SegmentLocationJsonMarshaller.getInstance().marshall(location, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static SegmentDimensionsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SegmentDimensionsJsonMarshaller();
        }
        return instance;
    }
}

