/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.Schedule;
import com.amazonaws.services.pinpoint.model.transform.QuietTimeJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class ScheduleJsonUnmarshaller
implements Unmarshaller<Schedule, JsonUnmarshallerContext> {
    private static ScheduleJsonUnmarshaller instance;

    ScheduleJsonUnmarshaller() {
    }

    public Schedule unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        Schedule schedule = new Schedule();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("EndTime")) {
                schedule.setEndTime(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Frequency")) {
                schedule.setFrequency(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("IsLocalTime")) {
                schedule.setIsLocalTime(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("QuietTime")) {
                schedule.setQuietTime(QuietTimeJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("StartTime")) {
                schedule.setStartTime(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Timezone")) {
                schedule.setTimezone(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return schedule;
    }

    public static ScheduleJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ScheduleJsonUnmarshaller();
        }
        return instance;
    }
}

