/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.QuietTime;
import com.amazonaws.services.pinpoint.model.Schedule;
import com.amazonaws.services.pinpoint.model.transform.QuietTimeJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;

class ScheduleJsonMarshaller {
    private static ScheduleJsonMarshaller instance;

    ScheduleJsonMarshaller() {
    }

    public void marshall(Schedule schedule, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (schedule.getEndTime() != null) {
            String endTime = schedule.getEndTime();
            jsonWriter.name("EndTime");
            jsonWriter.value(endTime);
        }
        if (schedule.getFrequency() != null) {
            String frequency = schedule.getFrequency();
            jsonWriter.name("Frequency");
            jsonWriter.value(frequency);
        }
        if (schedule.getIsLocalTime() != null) {
            Boolean isLocalTime = schedule.getIsLocalTime();
            jsonWriter.name("IsLocalTime");
            jsonWriter.value(isLocalTime.booleanValue());
        }
        if (schedule.getQuietTime() != null) {
            QuietTime quietTime = schedule.getQuietTime();
            jsonWriter.name("QuietTime");
            QuietTimeJsonMarshaller.getInstance().marshall(quietTime, jsonWriter);
        }
        if (schedule.getStartTime() != null) {
            String startTime = schedule.getStartTime();
            jsonWriter.name("StartTime");
            jsonWriter.value(startTime);
        }
        if (schedule.getTimezone() != null) {
            String timezone = schedule.getTimezone();
            jsonWriter.name("Timezone");
            jsonWriter.value(timezone);
        }
        jsonWriter.endObject();
    }

    public static ScheduleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ScheduleJsonMarshaller();
        }
        return instance;
    }
}

