/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.QuietTime;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class QuietTimeJsonUnmarshaller
implements Unmarshaller<QuietTime, JsonUnmarshallerContext> {
    private static QuietTimeJsonUnmarshaller instance;

    QuietTimeJsonUnmarshaller() {
    }

    public QuietTime unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        QuietTime quietTime = new QuietTime();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("End")) {
                quietTime.setEnd(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Start")) {
                quietTime.setStart(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return quietTime;
    }

    public static QuietTimeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new QuietTimeJsonUnmarshaller();
        }
        return instance;
    }
}

