/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.services.pinpoint.model.MessageBody;
import com.amazonaws.services.pinpoint.model.MethodNotAllowedException;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.google.gson.Gson;

public class MethodNotAllowedExceptionUnmarshaller
extends JsonErrorUnmarshaller {
    public MethodNotAllowedExceptionUnmarshaller() {
        super(MethodNotAllowedException.class);
    }

    public boolean match(JsonErrorResponseHandler.JsonErrorResponse error) throws Exception {
        return error.getErrorCode().equals("MethodNotAllowedException");
    }

    public AmazonServiceException unmarshall(JsonErrorResponseHandler.JsonErrorResponse error) throws Exception {
        Gson gson = new Gson();
        MethodNotAllowedException e = (MethodNotAllowedException)super.unmarshall(error);
        e.setErrorCode("MethodNotAllowedException");
        e.setAccessControlAllowOrigin(String.valueOf(error.get("AccessControlAllowOrigin")));
        e.setMessageBody((MessageBody)gson.fromJson(error.get("MessageBody"), MessageBody.class));
        return e;
    }
}

