/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.MessageConfiguration;
import com.amazonaws.services.pinpoint.model.transform.MessageJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class MessageConfigurationJsonUnmarshaller
implements Unmarshaller<MessageConfiguration, JsonUnmarshallerContext> {
    private static MessageConfigurationJsonUnmarshaller instance;

    MessageConfigurationJsonUnmarshaller() {
    }

    public MessageConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        MessageConfiguration messageConfiguration = new MessageConfiguration();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("APNSMessage")) {
                messageConfiguration.setAPNSMessage(MessageJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("DefaultMessage")) {
                messageConfiguration.setDefaultMessage(MessageJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("GCMMessage")) {
                messageConfiguration.setGCMMessage(MessageJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return messageConfiguration;
    }

    public static MessageConfigurationJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MessageConfigurationJsonUnmarshaller();
        }
        return instance;
    }
}

