/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.Message;
import com.amazonaws.services.pinpoint.model.MessageConfiguration;
import com.amazonaws.services.pinpoint.model.transform.MessageJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;

class MessageConfigurationJsonMarshaller {
    private static MessageConfigurationJsonMarshaller instance;

    MessageConfigurationJsonMarshaller() {
    }

    public void marshall(MessageConfiguration messageConfiguration, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (messageConfiguration.getAPNSMessage() != null) {
            Message aPNSMessage = messageConfiguration.getAPNSMessage();
            jsonWriter.name("APNSMessage");
            MessageJsonMarshaller.getInstance().marshall(aPNSMessage, jsonWriter);
        }
        if (messageConfiguration.getDefaultMessage() != null) {
            Message defaultMessage = messageConfiguration.getDefaultMessage();
            jsonWriter.name("DefaultMessage");
            MessageJsonMarshaller.getInstance().marshall(defaultMessage, jsonWriter);
        }
        if (messageConfiguration.getGCMMessage() != null) {
            Message gCMMessage = messageConfiguration.getGCMMessage();
            jsonWriter.name("GCMMessage");
            MessageJsonMarshaller.getInstance().marshall(gCMMessage, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static MessageConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MessageConfigurationJsonMarshaller();
        }
        return instance;
    }
}

