/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.services.pinpoint.model.InternalServerErrorException;
import com.amazonaws.services.pinpoint.model.MessageBody;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.google.gson.Gson;

public class InternalServerErrorExceptionUnmarshaller
extends JsonErrorUnmarshaller {
    public InternalServerErrorExceptionUnmarshaller() {
        super(InternalServerErrorException.class);
    }

    public boolean match(JsonErrorResponseHandler.JsonErrorResponse error) throws Exception {
        return error.getErrorCode().equals("InternalServerErrorException");
    }

    public AmazonServiceException unmarshall(JsonErrorResponseHandler.JsonErrorResponse error) throws Exception {
        Gson gson = new Gson();
        InternalServerErrorException e = (InternalServerErrorException)super.unmarshall(error);
        e.setErrorCode("InternalServerErrorException");
        e.setAccessControlAllowOrigin(String.valueOf(error.get("AccessControlAllowOrigin")));
        e.setMessageBody((MessageBody)gson.fromJson(error.get("MessageBody"), MessageBody.class));
        return e;
    }
}

