/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.ImportJobResource;
import com.amazonaws.services.pinpoint.model.ImportJobResponse;
import com.amazonaws.services.pinpoint.model.transform.ImportJobResourceJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.List;

class ImportJobResponseJsonMarshaller {
    private static ImportJobResponseJsonMarshaller instance;

    ImportJobResponseJsonMarshaller() {
    }

    public void marshall(ImportJobResponse importJobResponse, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (importJobResponse.getApplicationId() != null) {
            String applicationId = importJobResponse.getApplicationId();
            jsonWriter.name("ApplicationId");
            jsonWriter.value(applicationId);
        }
        if (importJobResponse.getCompletedPieces() != null) {
            Integer completedPieces = importJobResponse.getCompletedPieces();
            jsonWriter.name("CompletedPieces");
            jsonWriter.value((Number)completedPieces);
        }
        if (importJobResponse.getCompletionDate() != null) {
            String completionDate = importJobResponse.getCompletionDate();
            jsonWriter.name("CompletionDate");
            jsonWriter.value(completionDate);
        }
        if (importJobResponse.getCreationDate() != null) {
            String creationDate = importJobResponse.getCreationDate();
            jsonWriter.name("CreationDate");
            jsonWriter.value(creationDate);
        }
        if (importJobResponse.getDefinition() != null) {
            ImportJobResource definition = importJobResponse.getDefinition();
            jsonWriter.name("Definition");
            ImportJobResourceJsonMarshaller.getInstance().marshall(definition, jsonWriter);
        }
        if (importJobResponse.getFailedPieces() != null) {
            Integer failedPieces = importJobResponse.getFailedPieces();
            jsonWriter.name("FailedPieces");
            jsonWriter.value((Number)failedPieces);
        }
        if (importJobResponse.getFailures() != null) {
            List<String> failures = importJobResponse.getFailures();
            jsonWriter.name("Failures");
            jsonWriter.beginArray();
            for (String failuresItem : failures) {
                if (failuresItem == null) continue;
                jsonWriter.value(failuresItem);
            }
            jsonWriter.endArray();
        }
        if (importJobResponse.getId() != null) {
            String id = importJobResponse.getId();
            jsonWriter.name("Id");
            jsonWriter.value(id);
        }
        if (importJobResponse.getJobStatus() != null) {
            String jobStatus = importJobResponse.getJobStatus();
            jsonWriter.name("JobStatus");
            jsonWriter.value(jobStatus);
        }
        if (importJobResponse.getTotalFailures() != null) {
            Integer totalFailures = importJobResponse.getTotalFailures();
            jsonWriter.name("TotalFailures");
            jsonWriter.value((Number)totalFailures);
        }
        if (importJobResponse.getTotalPieces() != null) {
            Integer totalPieces = importJobResponse.getTotalPieces();
            jsonWriter.name("TotalPieces");
            jsonWriter.value((Number)totalPieces);
        }
        if (importJobResponse.getTotalProcessed() != null) {
            Integer totalProcessed = importJobResponse.getTotalProcessed();
            jsonWriter.name("TotalProcessed");
            jsonWriter.value((Number)totalProcessed);
        }
        if (importJobResponse.getType() != null) {
            String type = importJobResponse.getType();
            jsonWriter.name("Type");
            jsonWriter.value(type);
        }
        jsonWriter.endObject();
    }

    public static ImportJobResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ImportJobResponseJsonMarshaller();
        }
        return instance;
    }
}

