/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetSegmentsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetSegmentsRequestMarshaller
implements Marshaller<Request<GetSegmentsRequest>, GetSegmentsRequest> {
    public Request<GetSegmentsRequest> marshall(GetSegmentsRequest getSegmentsRequest) {
        if (getSegmentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetSegmentsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSegmentsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getSegmentsRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getSegmentsRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/segments";
        uriResourcePath = uriResourcePath.replace("{application-id}", getSegmentsRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getSegmentsRequest.getApplicationId()));
        if (getSegmentsRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString((String)getSegmentsRequest.getPageSize()));
        }
        if (getSegmentsRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString((String)getSegmentsRequest.getToken()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

