/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetSegmentVersionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetSegmentVersionsRequestMarshaller
implements Marshaller<Request<GetSegmentVersionsRequest>, GetSegmentVersionsRequest> {
    public Request<GetSegmentVersionsRequest> marshall(GetSegmentVersionsRequest getSegmentVersionsRequest) {
        if (getSegmentVersionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetSegmentVersionsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSegmentVersionsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getSegmentVersionsRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getSegmentVersionsRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/segments/{segment-id}/versions";
        uriResourcePath = uriResourcePath.replace("{application-id}", getSegmentVersionsRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getSegmentVersionsRequest.getApplicationId()));
        if (getSegmentVersionsRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString((String)getSegmentVersionsRequest.getPageSize()));
        }
        uriResourcePath = uriResourcePath.replace("{segment-id}", getSegmentVersionsRequest.getSegmentId() == null ? "" : StringUtils.fromString((String)getSegmentVersionsRequest.getSegmentId()));
        if (getSegmentVersionsRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString((String)getSegmentVersionsRequest.getToken()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

