/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetSegmentVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetSegmentVersionRequestMarshaller
implements Marshaller<Request<GetSegmentVersionRequest>, GetSegmentVersionRequest> {
    public Request<GetSegmentVersionRequest> marshall(GetSegmentVersionRequest getSegmentVersionRequest) {
        if (getSegmentVersionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetSegmentVersionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSegmentVersionRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getSegmentVersionRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getSegmentVersionRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/segments/{segment-id}/versions/{version}";
        uriResourcePath = uriResourcePath.replace("{application-id}", getSegmentVersionRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getSegmentVersionRequest.getApplicationId()));
        uriResourcePath = uriResourcePath.replace("{segment-id}", getSegmentVersionRequest.getSegmentId() == null ? "" : StringUtils.fromString((String)getSegmentVersionRequest.getSegmentId()));
        uriResourcePath = uriResourcePath.replace("{version}", getSegmentVersionRequest.getVersion() == null ? "" : StringUtils.fromString((String)getSegmentVersionRequest.getVersion()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

