/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetSegmentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetSegmentRequestMarshaller
implements Marshaller<Request<GetSegmentRequest>, GetSegmentRequest> {
    public Request<GetSegmentRequest> marshall(GetSegmentRequest getSegmentRequest) {
        if (getSegmentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetSegmentRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSegmentRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getSegmentRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getSegmentRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/segments/{segment-id}";
        uriResourcePath = uriResourcePath.replace("{application-id}", getSegmentRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getSegmentRequest.getApplicationId()));
        uriResourcePath = uriResourcePath.replace("{segment-id}", getSegmentRequest.getSegmentId() == null ? "" : StringUtils.fromString((String)getSegmentRequest.getSegmentId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

