/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetSegmentImportJobsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetSegmentImportJobsRequestMarshaller
implements Marshaller<Request<GetSegmentImportJobsRequest>, GetSegmentImportJobsRequest> {
    public Request<GetSegmentImportJobsRequest> marshall(GetSegmentImportJobsRequest getSegmentImportJobsRequest) {
        if (getSegmentImportJobsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetSegmentImportJobsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSegmentImportJobsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getSegmentImportJobsRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getSegmentImportJobsRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/segments/{segment-id}/jobs/import";
        uriResourcePath = uriResourcePath.replace("{application-id}", getSegmentImportJobsRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getSegmentImportJobsRequest.getApplicationId()));
        if (getSegmentImportJobsRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString((String)getSegmentImportJobsRequest.getPageSize()));
        }
        uriResourcePath = uriResourcePath.replace("{segment-id}", getSegmentImportJobsRequest.getSegmentId() == null ? "" : StringUtils.fromString((String)getSegmentImportJobsRequest.getSegmentId()));
        if (getSegmentImportJobsRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString((String)getSegmentImportJobsRequest.getToken()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

