/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetImportJobsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetImportJobsRequestMarshaller
implements Marshaller<Request<GetImportJobsRequest>, GetImportJobsRequest> {
    public Request<GetImportJobsRequest> marshall(GetImportJobsRequest getImportJobsRequest) {
        if (getImportJobsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetImportJobsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getImportJobsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getImportJobsRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getImportJobsRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/jobs/import";
        uriResourcePath = uriResourcePath.replace("{application-id}", getImportJobsRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getImportJobsRequest.getApplicationId()));
        if (getImportJobsRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString((String)getImportJobsRequest.getPageSize()));
        }
        if (getImportJobsRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString((String)getImportJobsRequest.getToken()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

