/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetImportJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetImportJobRequestMarshaller
implements Marshaller<Request<GetImportJobRequest>, GetImportJobRequest> {
    public Request<GetImportJobRequest> marshall(GetImportJobRequest getImportJobRequest) {
        if (getImportJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetImportJobRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getImportJobRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getImportJobRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getImportJobRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/jobs/import/{job-id}";
        uriResourcePath = uriResourcePath.replace("{application-id}", getImportJobRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getImportJobRequest.getApplicationId()));
        uriResourcePath = uriResourcePath.replace("{job-id}", getImportJobRequest.getJobId() == null ? "" : StringUtils.fromString((String)getImportJobRequest.getJobId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

