/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetGcmChannelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetGcmChannelRequestMarshaller
implements Marshaller<Request<GetGcmChannelRequest>, GetGcmChannelRequest> {
    public Request<GetGcmChannelRequest> marshall(GetGcmChannelRequest getGcmChannelRequest) {
        if (getGcmChannelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetGcmChannelRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getGcmChannelRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getGcmChannelRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getGcmChannelRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/channels/gcm";
        uriResourcePath = uriResourcePath.replace("{application-id}", getGcmChannelRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getGcmChannelRequest.getApplicationId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

