/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetEndpointRequestMarshaller
implements Marshaller<Request<GetEndpointRequest>, GetEndpointRequest> {
    public Request<GetEndpointRequest> marshall(GetEndpointRequest getEndpointRequest) {
        if (getEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetEndpointRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getEndpointRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getEndpointRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getEndpointRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/endpoints/{endpoint-id}";
        uriResourcePath = uriResourcePath.replace("{application-id}", getEndpointRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getEndpointRequest.getApplicationId()));
        uriResourcePath = uriResourcePath.replace("{endpoint-id}", getEndpointRequest.getEndpointId() == null ? "" : StringUtils.fromString((String)getEndpointRequest.getEndpointId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

