/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetCampaignsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetCampaignsRequestMarshaller
implements Marshaller<Request<GetCampaignsRequest>, GetCampaignsRequest> {
    public Request<GetCampaignsRequest> marshall(GetCampaignsRequest getCampaignsRequest) {
        if (getCampaignsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetCampaignsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getCampaignsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getCampaignsRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getCampaignsRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/campaigns";
        uriResourcePath = uriResourcePath.replace("{application-id}", getCampaignsRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getCampaignsRequest.getApplicationId()));
        if (getCampaignsRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString((String)getCampaignsRequest.getPageSize()));
        }
        if (getCampaignsRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString((String)getCampaignsRequest.getToken()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

