/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetCampaignVersionsRequestMarshaller
implements Marshaller<Request<GetCampaignVersionsRequest>, GetCampaignVersionsRequest> {
    public Request<GetCampaignVersionsRequest> marshall(GetCampaignVersionsRequest getCampaignVersionsRequest) {
        if (getCampaignVersionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetCampaignVersionsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getCampaignVersionsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getCampaignVersionsRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getCampaignVersionsRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}/versions";
        uriResourcePath = uriResourcePath.replace("{application-id}", getCampaignVersionsRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getCampaignVersionsRequest.getApplicationId()));
        uriResourcePath = uriResourcePath.replace("{campaign-id}", getCampaignVersionsRequest.getCampaignId() == null ? "" : StringUtils.fromString((String)getCampaignVersionsRequest.getCampaignId()));
        if (getCampaignVersionsRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString((String)getCampaignVersionsRequest.getPageSize()));
        }
        if (getCampaignVersionsRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString((String)getCampaignVersionsRequest.getToken()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

