/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetCampaignVersionRequestMarshaller
implements Marshaller<Request<GetCampaignVersionRequest>, GetCampaignVersionRequest> {
    public Request<GetCampaignVersionRequest> marshall(GetCampaignVersionRequest getCampaignVersionRequest) {
        if (getCampaignVersionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetCampaignVersionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getCampaignVersionRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getCampaignVersionRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getCampaignVersionRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}/versions/{version}";
        uriResourcePath = uriResourcePath.replace("{application-id}", getCampaignVersionRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getCampaignVersionRequest.getApplicationId()));
        uriResourcePath = uriResourcePath.replace("{campaign-id}", getCampaignVersionRequest.getCampaignId() == null ? "" : StringUtils.fromString((String)getCampaignVersionRequest.getCampaignId()));
        uriResourcePath = uriResourcePath.replace("{version}", getCampaignVersionRequest.getVersion() == null ? "" : StringUtils.fromString((String)getCampaignVersionRequest.getVersion()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

