/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetCampaignRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetCampaignRequestMarshaller
implements Marshaller<Request<GetCampaignRequest>, GetCampaignRequest> {
    public Request<GetCampaignRequest> marshall(GetCampaignRequest getCampaignRequest) {
        if (getCampaignRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetCampaignRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getCampaignRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getCampaignRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getCampaignRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}";
        uriResourcePath = uriResourcePath.replace("{application-id}", getCampaignRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getCampaignRequest.getApplicationId()));
        uriResourcePath = uriResourcePath.replace("{campaign-id}", getCampaignRequest.getCampaignId() == null ? "" : StringUtils.fromString((String)getCampaignRequest.getCampaignId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

