/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetCampaignActivitiesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetCampaignActivitiesRequestMarshaller
implements Marshaller<Request<GetCampaignActivitiesRequest>, GetCampaignActivitiesRequest> {
    public Request<GetCampaignActivitiesRequest> marshall(GetCampaignActivitiesRequest getCampaignActivitiesRequest) {
        if (getCampaignActivitiesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetCampaignActivitiesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getCampaignActivitiesRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getCampaignActivitiesRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getCampaignActivitiesRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}/activities";
        uriResourcePath = uriResourcePath.replace("{application-id}", getCampaignActivitiesRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getCampaignActivitiesRequest.getApplicationId()));
        uriResourcePath = uriResourcePath.replace("{campaign-id}", getCampaignActivitiesRequest.getCampaignId() == null ? "" : StringUtils.fromString((String)getCampaignActivitiesRequest.getCampaignId()));
        if (getCampaignActivitiesRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString((String)getCampaignActivitiesRequest.getPageSize()));
        }
        if (getCampaignActivitiesRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString((String)getCampaignActivitiesRequest.getToken()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

