/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetApplicationSettingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetApplicationSettingsRequestMarshaller
implements Marshaller<Request<GetApplicationSettingsRequest>, GetApplicationSettingsRequest> {
    public Request<GetApplicationSettingsRequest> marshall(GetApplicationSettingsRequest getApplicationSettingsRequest) {
        if (getApplicationSettingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetApplicationSettingsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getApplicationSettingsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getApplicationSettingsRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getApplicationSettingsRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/settings";
        uriResourcePath = uriResourcePath.replace("{application-id}", getApplicationSettingsRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getApplicationSettingsRequest.getApplicationId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

