/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.GetApnsChannelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetApnsChannelRequestMarshaller
implements Marshaller<Request<GetApnsChannelRequest>, GetApnsChannelRequest> {
    public Request<GetApnsChannelRequest> marshall(GetApnsChannelRequest getApnsChannelRequest) {
        if (getApnsChannelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetApnsChannelRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getApnsChannelRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        if (getApnsChannelRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)getApnsChannelRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/channels/apns";
        uriResourcePath = uriResourcePath.replace("{application-id}", getApnsChannelRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)getApnsChannelRequest.getApplicationId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

