/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.services.pinpoint.model.ForbiddenException;
import com.amazonaws.services.pinpoint.model.MessageBody;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.google.gson.Gson;

public class ForbiddenExceptionUnmarshaller
extends JsonErrorUnmarshaller {
    public ForbiddenExceptionUnmarshaller() {
        super(ForbiddenException.class);
    }

    public boolean match(JsonErrorResponseHandler.JsonErrorResponse error) throws Exception {
        return error.getErrorCode().equals("ForbiddenException");
    }

    public AmazonServiceException unmarshall(JsonErrorResponseHandler.JsonErrorResponse error) throws Exception {
        Gson gson = new Gson();
        ForbiddenException e = (ForbiddenException)super.unmarshall(error);
        e.setErrorCode("ForbiddenException");
        e.setAccessControlAllowOrigin(String.valueOf(error.get("AccessControlAllowOrigin")));
        e.setMessageBody((MessageBody)gson.fromJson(error.get("MessageBody"), MessageBody.class));
        return e;
    }
}

