/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.EndpointResponse;
import com.amazonaws.services.pinpoint.model.transform.EndpointDemographicJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointLocationJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointUserJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class EndpointResponseJsonUnmarshaller
implements Unmarshaller<EndpointResponse, JsonUnmarshallerContext> {
    private static EndpointResponseJsonUnmarshaller instance;

    EndpointResponseJsonUnmarshaller() {
    }

    public EndpointResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        EndpointResponse endpointResponse = new EndpointResponse();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("Address")) {
                endpointResponse.setAddress(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ApplicationId")) {
                endpointResponse.setApplicationId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Attributes")) {
                endpointResponse.setAttributes(new MapUnmarshaller((Unmarshaller)new ListUnmarshaller((Unmarshaller)SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance())).unmarshall(context));
                continue;
            }
            if (name.equals("ChannelType")) {
                endpointResponse.setChannelType(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("CohortId")) {
                endpointResponse.setCohortId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("CreationDate")) {
                endpointResponse.setCreationDate(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Demographic")) {
                endpointResponse.setDemographic(EndpointDemographicJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("EffectiveDate")) {
                endpointResponse.setEffectiveDate(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("EndpointStatus")) {
                endpointResponse.setEndpointStatus(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Id")) {
                endpointResponse.setId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Location")) {
                endpointResponse.setLocation(EndpointLocationJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Metrics")) {
                endpointResponse.setMetrics(new MapUnmarshaller((Unmarshaller)SimpleTypeJsonUnmarshallers.DoubleJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("OptOut")) {
                endpointResponse.setOptOut(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("RequestId")) {
                endpointResponse.setRequestId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ShardId")) {
                endpointResponse.setShardId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("User")) {
                endpointResponse.setUser(EndpointUserJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return endpointResponse;
    }

    public static EndpointResponseJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointResponseJsonUnmarshaller();
        }
        return instance;
    }
}

