/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.EndpointDemographic;
import com.amazonaws.services.pinpoint.model.EndpointLocation;
import com.amazonaws.services.pinpoint.model.EndpointResponse;
import com.amazonaws.services.pinpoint.model.EndpointUser;
import com.amazonaws.services.pinpoint.model.transform.EndpointDemographicJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointLocationJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointUserJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.List;
import java.util.Map;

class EndpointResponseJsonMarshaller {
    private static EndpointResponseJsonMarshaller instance;

    EndpointResponseJsonMarshaller() {
    }

    public void marshall(EndpointResponse endpointResponse, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (endpointResponse.getAddress() != null) {
            String address = endpointResponse.getAddress();
            jsonWriter.name("Address");
            jsonWriter.value(address);
        }
        if (endpointResponse.getApplicationId() != null) {
            String applicationId = endpointResponse.getApplicationId();
            jsonWriter.name("ApplicationId");
            jsonWriter.value(applicationId);
        }
        if (endpointResponse.getAttributes() != null) {
            Map<String, List<String>> attributes = endpointResponse.getAttributes();
            jsonWriter.name("Attributes");
            jsonWriter.beginObject();
            for (Map.Entry<String, List<String>> entry : attributes.entrySet()) {
                List<String> attributesValue = entry.getValue();
                if (attributesValue == null) continue;
                jsonWriter.name(entry.getKey());
                jsonWriter.beginArray();
                for (String attributesValueItem : attributesValue) {
                    if (attributesValueItem == null) continue;
                    jsonWriter.value(attributesValueItem);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        if (endpointResponse.getChannelType() != null) {
            String channelType = endpointResponse.getChannelType();
            jsonWriter.name("ChannelType");
            jsonWriter.value(channelType);
        }
        if (endpointResponse.getCohortId() != null) {
            String cohortId = endpointResponse.getCohortId();
            jsonWriter.name("CohortId");
            jsonWriter.value(cohortId);
        }
        if (endpointResponse.getCreationDate() != null) {
            String creationDate = endpointResponse.getCreationDate();
            jsonWriter.name("CreationDate");
            jsonWriter.value(creationDate);
        }
        if (endpointResponse.getDemographic() != null) {
            EndpointDemographic demographic = endpointResponse.getDemographic();
            jsonWriter.name("Demographic");
            EndpointDemographicJsonMarshaller.getInstance().marshall(demographic, jsonWriter);
        }
        if (endpointResponse.getEffectiveDate() != null) {
            String effectiveDate = endpointResponse.getEffectiveDate();
            jsonWriter.name("EffectiveDate");
            jsonWriter.value(effectiveDate);
        }
        if (endpointResponse.getEndpointStatus() != null) {
            String endpointStatus = endpointResponse.getEndpointStatus();
            jsonWriter.name("EndpointStatus");
            jsonWriter.value(endpointStatus);
        }
        if (endpointResponse.getId() != null) {
            String id = endpointResponse.getId();
            jsonWriter.name("Id");
            jsonWriter.value(id);
        }
        if (endpointResponse.getLocation() != null) {
            EndpointLocation location = endpointResponse.getLocation();
            jsonWriter.name("Location");
            EndpointLocationJsonMarshaller.getInstance().marshall(location, jsonWriter);
        }
        if (endpointResponse.getMetrics() != null) {
            Map<String, Double> metrics = endpointResponse.getMetrics();
            jsonWriter.name("Metrics");
            jsonWriter.beginObject();
            for (Map.Entry<String, Object> entry : metrics.entrySet()) {
                Double metricsValue = (Double)entry.getValue();
                if (metricsValue == null) continue;
                jsonWriter.name(entry.getKey());
                jsonWriter.value((Number)metricsValue);
            }
            jsonWriter.endObject();
        }
        if (endpointResponse.getOptOut() != null) {
            String optOut = endpointResponse.getOptOut();
            jsonWriter.name("OptOut");
            jsonWriter.value(optOut);
        }
        if (endpointResponse.getRequestId() != null) {
            String requestId = endpointResponse.getRequestId();
            jsonWriter.name("RequestId");
            jsonWriter.value(requestId);
        }
        if (endpointResponse.getShardId() != null) {
            String shardId = endpointResponse.getShardId();
            jsonWriter.name("ShardId");
            jsonWriter.value(shardId);
        }
        if (endpointResponse.getUser() != null) {
            EndpointUser user = endpointResponse.getUser();
            jsonWriter.name("User");
            EndpointUserJsonMarshaller.getInstance().marshall(user, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static EndpointResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointResponseJsonMarshaller();
        }
        return instance;
    }
}

