/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.EndpointRequest;
import com.amazonaws.services.pinpoint.model.transform.EndpointDemographicJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointLocationJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointUserJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class EndpointRequestJsonUnmarshaller
implements Unmarshaller<EndpointRequest, JsonUnmarshallerContext> {
    private static EndpointRequestJsonUnmarshaller instance;

    EndpointRequestJsonUnmarshaller() {
    }

    public EndpointRequest unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        EndpointRequest endpointRequest = new EndpointRequest();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("Address")) {
                endpointRequest.setAddress(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Attributes")) {
                endpointRequest.setAttributes(new MapUnmarshaller((Unmarshaller)new ListUnmarshaller((Unmarshaller)SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance())).unmarshall(context));
                continue;
            }
            if (name.equals("ChannelType")) {
                endpointRequest.setChannelType(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Demographic")) {
                endpointRequest.setDemographic(EndpointDemographicJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("EffectiveDate")) {
                endpointRequest.setEffectiveDate(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("EndpointStatus")) {
                endpointRequest.setEndpointStatus(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Location")) {
                endpointRequest.setLocation(EndpointLocationJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Metrics")) {
                endpointRequest.setMetrics(new MapUnmarshaller((Unmarshaller)SimpleTypeJsonUnmarshallers.DoubleJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("OptOut")) {
                endpointRequest.setOptOut(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("RequestId")) {
                endpointRequest.setRequestId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("User")) {
                endpointRequest.setUser(EndpointUserJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return endpointRequest;
    }

    public static EndpointRequestJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointRequestJsonUnmarshaller();
        }
        return instance;
    }
}

