/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.EndpointDemographic;
import com.amazonaws.services.pinpoint.model.EndpointLocation;
import com.amazonaws.services.pinpoint.model.EndpointRequest;
import com.amazonaws.services.pinpoint.model.EndpointUser;
import com.amazonaws.services.pinpoint.model.transform.EndpointDemographicJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointLocationJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointUserJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.List;
import java.util.Map;

class EndpointRequestJsonMarshaller {
    private static EndpointRequestJsonMarshaller instance;

    EndpointRequestJsonMarshaller() {
    }

    public void marshall(EndpointRequest endpointRequest, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (endpointRequest.getAddress() != null) {
            String address = endpointRequest.getAddress();
            jsonWriter.name("Address");
            jsonWriter.value(address);
        }
        if (endpointRequest.getAttributes() != null) {
            Map<String, List<String>> attributes = endpointRequest.getAttributes();
            jsonWriter.name("Attributes");
            jsonWriter.beginObject();
            for (Map.Entry<String, List<String>> entry : attributes.entrySet()) {
                List<String> attributesValue = entry.getValue();
                if (attributesValue == null) continue;
                jsonWriter.name(entry.getKey());
                jsonWriter.beginArray();
                for (String attributesValueItem : attributesValue) {
                    if (attributesValueItem == null) continue;
                    jsonWriter.value(attributesValueItem);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        if (endpointRequest.getChannelType() != null) {
            String channelType = endpointRequest.getChannelType();
            jsonWriter.name("ChannelType");
            jsonWriter.value(channelType);
        }
        if (endpointRequest.getDemographic() != null) {
            EndpointDemographic demographic = endpointRequest.getDemographic();
            jsonWriter.name("Demographic");
            EndpointDemographicJsonMarshaller.getInstance().marshall(demographic, jsonWriter);
        }
        if (endpointRequest.getEffectiveDate() != null) {
            String effectiveDate = endpointRequest.getEffectiveDate();
            jsonWriter.name("EffectiveDate");
            jsonWriter.value(effectiveDate);
        }
        if (endpointRequest.getEndpointStatus() != null) {
            String endpointStatus = endpointRequest.getEndpointStatus();
            jsonWriter.name("EndpointStatus");
            jsonWriter.value(endpointStatus);
        }
        if (endpointRequest.getLocation() != null) {
            EndpointLocation location = endpointRequest.getLocation();
            jsonWriter.name("Location");
            EndpointLocationJsonMarshaller.getInstance().marshall(location, jsonWriter);
        }
        if (endpointRequest.getMetrics() != null) {
            Map<String, Double> metrics = endpointRequest.getMetrics();
            jsonWriter.name("Metrics");
            jsonWriter.beginObject();
            for (Map.Entry<String, Object> entry : metrics.entrySet()) {
                Double metricsValue = (Double)entry.getValue();
                if (metricsValue == null) continue;
                jsonWriter.name(entry.getKey());
                jsonWriter.value((Number)metricsValue);
            }
            jsonWriter.endObject();
        }
        if (endpointRequest.getOptOut() != null) {
            String optOut = endpointRequest.getOptOut();
            jsonWriter.name("OptOut");
            jsonWriter.value(optOut);
        }
        if (endpointRequest.getRequestId() != null) {
            String requestId = endpointRequest.getRequestId();
            jsonWriter.name("RequestId");
            jsonWriter.value(requestId);
        }
        if (endpointRequest.getUser() != null) {
            EndpointUser user = endpointRequest.getUser();
            jsonWriter.name("User");
            EndpointUserJsonMarshaller.getInstance().marshall(user, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static EndpointRequestJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointRequestJsonMarshaller();
        }
        return instance;
    }
}

