/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.EndpointLocation;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class EndpointLocationJsonUnmarshaller
implements Unmarshaller<EndpointLocation, JsonUnmarshallerContext> {
    private static EndpointLocationJsonUnmarshaller instance;

    EndpointLocationJsonUnmarshaller() {
    }

    public EndpointLocation unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        EndpointLocation endpointLocation = new EndpointLocation();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("City")) {
                endpointLocation.setCity(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Country")) {
                endpointLocation.setCountry(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Latitude")) {
                endpointLocation.setLatitude(SimpleTypeJsonUnmarshallers.DoubleJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Longitude")) {
                endpointLocation.setLongitude(SimpleTypeJsonUnmarshallers.DoubleJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("PostalCode")) {
                endpointLocation.setPostalCode(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Region")) {
                endpointLocation.setRegion(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return endpointLocation;
    }

    public static EndpointLocationJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointLocationJsonUnmarshaller();
        }
        return instance;
    }
}

