/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.EndpointLocation;
import com.amazonaws.util.json.AwsJsonWriter;

class EndpointLocationJsonMarshaller {
    private static EndpointLocationJsonMarshaller instance;

    EndpointLocationJsonMarshaller() {
    }

    public void marshall(EndpointLocation endpointLocation, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (endpointLocation.getCity() != null) {
            String city = endpointLocation.getCity();
            jsonWriter.name("City");
            jsonWriter.value(city);
        }
        if (endpointLocation.getCountry() != null) {
            String country = endpointLocation.getCountry();
            jsonWriter.name("Country");
            jsonWriter.value(country);
        }
        if (endpointLocation.getLatitude() != null) {
            Double latitude = endpointLocation.getLatitude();
            jsonWriter.name("Latitude");
            jsonWriter.value((Number)latitude);
        }
        if (endpointLocation.getLongitude() != null) {
            Double longitude = endpointLocation.getLongitude();
            jsonWriter.name("Longitude");
            jsonWriter.value((Number)longitude);
        }
        if (endpointLocation.getPostalCode() != null) {
            String postalCode = endpointLocation.getPostalCode();
            jsonWriter.name("PostalCode");
            jsonWriter.value(postalCode);
        }
        if (endpointLocation.getRegion() != null) {
            String region = endpointLocation.getRegion();
            jsonWriter.name("Region");
            jsonWriter.value(region);
        }
        jsonWriter.endObject();
    }

    public static EndpointLocationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointLocationJsonMarshaller();
        }
        return instance;
    }
}

