/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.EndpointBatchItem;
import com.amazonaws.services.pinpoint.model.transform.EndpointDemographicJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointLocationJsonUnmarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointUserJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class EndpointBatchItemJsonUnmarshaller
implements Unmarshaller<EndpointBatchItem, JsonUnmarshallerContext> {
    private static EndpointBatchItemJsonUnmarshaller instance;

    EndpointBatchItemJsonUnmarshaller() {
    }

    public EndpointBatchItem unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        EndpointBatchItem endpointBatchItem = new EndpointBatchItem();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("Address")) {
                endpointBatchItem.setAddress(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Attributes")) {
                endpointBatchItem.setAttributes(new MapUnmarshaller((Unmarshaller)new ListUnmarshaller((Unmarshaller)SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance())).unmarshall(context));
                continue;
            }
            if (name.equals("ChannelType")) {
                endpointBatchItem.setChannelType(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Demographic")) {
                endpointBatchItem.setDemographic(EndpointDemographicJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("EffectiveDate")) {
                endpointBatchItem.setEffectiveDate(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("EndpointStatus")) {
                endpointBatchItem.setEndpointStatus(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Id")) {
                endpointBatchItem.setId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Location")) {
                endpointBatchItem.setLocation(EndpointLocationJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Metrics")) {
                endpointBatchItem.setMetrics(new MapUnmarshaller((Unmarshaller)SimpleTypeJsonUnmarshallers.DoubleJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("OptOut")) {
                endpointBatchItem.setOptOut(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("RequestId")) {
                endpointBatchItem.setRequestId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("User")) {
                endpointBatchItem.setUser(EndpointUserJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return endpointBatchItem;
    }

    public static EndpointBatchItemJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointBatchItemJsonUnmarshaller();
        }
        return instance;
    }
}

