/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.EndpointBatchItem;
import com.amazonaws.services.pinpoint.model.EndpointDemographic;
import com.amazonaws.services.pinpoint.model.EndpointLocation;
import com.amazonaws.services.pinpoint.model.EndpointUser;
import com.amazonaws.services.pinpoint.model.transform.EndpointDemographicJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointLocationJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.EndpointUserJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.List;
import java.util.Map;

class EndpointBatchItemJsonMarshaller {
    private static EndpointBatchItemJsonMarshaller instance;

    EndpointBatchItemJsonMarshaller() {
    }

    public void marshall(EndpointBatchItem endpointBatchItem, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (endpointBatchItem.getAddress() != null) {
            String address = endpointBatchItem.getAddress();
            jsonWriter.name("Address");
            jsonWriter.value(address);
        }
        if (endpointBatchItem.getAttributes() != null) {
            Map<String, List<String>> attributes = endpointBatchItem.getAttributes();
            jsonWriter.name("Attributes");
            jsonWriter.beginObject();
            for (Map.Entry<String, List<String>> entry : attributes.entrySet()) {
                List<String> attributesValue = entry.getValue();
                if (attributesValue == null) continue;
                jsonWriter.name(entry.getKey());
                jsonWriter.beginArray();
                for (String attributesValueItem : attributesValue) {
                    if (attributesValueItem == null) continue;
                    jsonWriter.value(attributesValueItem);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        if (endpointBatchItem.getChannelType() != null) {
            String channelType = endpointBatchItem.getChannelType();
            jsonWriter.name("ChannelType");
            jsonWriter.value(channelType);
        }
        if (endpointBatchItem.getDemographic() != null) {
            EndpointDemographic demographic = endpointBatchItem.getDemographic();
            jsonWriter.name("Demographic");
            EndpointDemographicJsonMarshaller.getInstance().marshall(demographic, jsonWriter);
        }
        if (endpointBatchItem.getEffectiveDate() != null) {
            String effectiveDate = endpointBatchItem.getEffectiveDate();
            jsonWriter.name("EffectiveDate");
            jsonWriter.value(effectiveDate);
        }
        if (endpointBatchItem.getEndpointStatus() != null) {
            String endpointStatus = endpointBatchItem.getEndpointStatus();
            jsonWriter.name("EndpointStatus");
            jsonWriter.value(endpointStatus);
        }
        if (endpointBatchItem.getId() != null) {
            String id = endpointBatchItem.getId();
            jsonWriter.name("Id");
            jsonWriter.value(id);
        }
        if (endpointBatchItem.getLocation() != null) {
            EndpointLocation location = endpointBatchItem.getLocation();
            jsonWriter.name("Location");
            EndpointLocationJsonMarshaller.getInstance().marshall(location, jsonWriter);
        }
        if (endpointBatchItem.getMetrics() != null) {
            Map<String, Double> metrics = endpointBatchItem.getMetrics();
            jsonWriter.name("Metrics");
            jsonWriter.beginObject();
            for (Map.Entry<String, Object> entry : metrics.entrySet()) {
                Double metricsValue = (Double)entry.getValue();
                if (metricsValue == null) continue;
                jsonWriter.name(entry.getKey());
                jsonWriter.value((Number)metricsValue);
            }
            jsonWriter.endObject();
        }
        if (endpointBatchItem.getOptOut() != null) {
            String optOut = endpointBatchItem.getOptOut();
            jsonWriter.name("OptOut");
            jsonWriter.value(optOut);
        }
        if (endpointBatchItem.getRequestId() != null) {
            String requestId = endpointBatchItem.getRequestId();
            jsonWriter.name("RequestId");
            jsonWriter.value(requestId);
        }
        if (endpointBatchItem.getUser() != null) {
            EndpointUser user = endpointBatchItem.getUser();
            jsonWriter.name("User");
            EndpointUserJsonMarshaller.getInstance().marshall(user, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static EndpointBatchItemJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointBatchItemJsonMarshaller();
        }
        return instance;
    }
}

