/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.DeleteSegmentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteSegmentRequestMarshaller
implements Marshaller<Request<DeleteSegmentRequest>, DeleteSegmentRequest> {
    public Request<DeleteSegmentRequest> marshall(DeleteSegmentRequest deleteSegmentRequest) {
        if (deleteSegmentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteSegmentRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteSegmentRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteSegmentRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)deleteSegmentRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/segments/{segment-id}";
        uriResourcePath = uriResourcePath.replace("{application-id}", deleteSegmentRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)deleteSegmentRequest.getApplicationId()));
        uriResourcePath = uriResourcePath.replace("{segment-id}", deleteSegmentRequest.getSegmentId() == null ? "" : StringUtils.fromString((String)deleteSegmentRequest.getSegmentId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

